<?php $title="Formulas and proofs syntax";
   include("header.inc"); ?>
   Logical connectives
<table>
<tr valign="top">
<td>
<table border cellpadding="4" cellspacing="2">
<tr>
<td><font color=blue><tt> & </tt></font></td>
<td>conjunction</td>
</tr>
<tr>
<td><font color=blue><tt> + </tt></font></td>
<td>disjunction</td>
</tr>
</table>
</td>

<td>
<table border cellpadding="4" cellspacing="2">
<tr>
<td><font color=blue><tt>=></tt></font></td>
<td>implication</td>
</tr>
<tr>
<td><font color=blue><tt><=></tt></font></td>
<td>equivalence</td>
</tr>
</table>
</td>

<td>
<table border cellpadding="4" cellspacing="2">
<tr>
<td><font color=blue><tt> - </tt></font></td>
<td>negation</td>
</tr>
</table>
</td>

<td>
<table border cellpadding="4" cellspacing="2">
<tr>
<td><font color=blue><tt>F</tt></font></td>
<td>false</td>
</tr>
</table>
</td>
</tr>
</table>


A proof is a sequence of proof lines.<br>
A proof line is either a formula,  
     the word <font color=blue><tt>assume</tt></font> followed by a formula, or the 
word <font color=blue><tt>therefore</font></tt> followed by a formula.<br>
This formula is the conclusion of the
proof line. 
Each proof line is terminated by a period.<br>
The word <font color=blue><tt>assume</tt></font> introduces an hypothesis.<br>
The word <font color=blue><tt>therefore</font></tt> removed the last introduced hypothesis.
<br>
A formula is <font color=blue><tt>usable</tt></font> on a proof line, if it is the conclusion of
a previous proof line whose hypotheses have not been removed.


<table border cellpadding="4" cellspacing="2">
<tr>
<th valign="top">  &nbsp;&nbsp; &nbsp;&nbsp;&nbsp; Proof Line &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;    </th>
<th valign="top">   Effects</th>
<th valign="top"> Conditions</th>
</tr>

<tr>
<td valign="top"><tt><font color=blue>assume</font></tt> <i>A</i><b>.</b>
</td>

<td valign="top">adds <i>A</i> to the end of the list
of the hypothesis of the previous proof line </td>
<td>  no conditions  </td>
</tr>

<tr>
<td valign="top">
<tt><font color=blue>therefore</font></tt> <i>A</i> => <i>B</i><b>.</b>
</td valign="top">
<td valign="top">removes the last introduced hypothesis.
This proof line is the application of the rule <tt><font color=blue> =>I</font></tt>
</td>
<td valign="top">
The removed hypothesis must be <i>A</i>. 
<br>
The formula <i>B</i> must be usable on the previous proof line.


<tr>

<td valign="top"><i>A<i><b>.</b>
</td>
<td valign="top"> no effects   </td>
<td valign="top">The formula <i>A</i> must be a copy of a formula usable
on this proof line or must be obtained by application of a 
<a href="rules.php">rule</a> to formulas usable on this line.
</td>

</tr>

</tr>
</table>

Operator priority : (high) <tt>- & + => <=></tt> (low)
<br>
Between two identical operations, the left operation is prioritary, except for implication
<p>
<table border cellpadding="4" cellspacing="2">
<tr>
<td>
<table>
<tr>
<td><i>A</i> & <i>B</i> &  <i>C</i></td>
<td>est</td>
<td>(<i>A</i> & <i>B</i>)&  <i>C</i></td>
</tr>
<tr>
<td><i>A</i> <tt>+</tt> <i>B</i> <tt>+</tt> <i>C</i></td>
<td>est</td>
<td>(<i>A</i> <tt>+</tt> <i>B</i>) <tt>+</tt> <i>C</i></td>
</tr>
<tr>
<td><i>A</i> <tt>=></tt> <i>B</i> <tt>=></tt> <i>C</i></td>
<td>est</td>
<td><i>A</i> <tt>=></tt> (<i>B</i> <tt>=></tt> <i>C)</i></td>
</tr>
</table>
</td>
<td>
<table>
<tr>
<td><i>A</i> & <i>B</i> <tt>+</tt> <i>C</i></td>
<td>est</td>
<td>(<i>A</i> & <i>B</i>) <tt>+</tt> <i>C</i></td>
</tr>
<tr>
<td><i>A</i> & <i>B</i> <tt>=></tt> 
  <i>C</i> <tt>+</tt> <i>D</i></td>
<td>est</td>
<td>(<i>A</i> & <i>B</i>) <tt>=></tt> 
  (<i>C</i> <tt>+</tt> <i>D</i>)</td>
</tr>
<tr>
<td><tt>-</tt> <i>A</i> <tt>+</tt> <i>B</i></td>
<td>est</td>
<td>(<tt>-</tt> <i>A</i>) <tt>+</tt> <i>B</i></td>
</tr>
</table>
</td>
</tr>
</table>
<?php include("footer.inc"); ?>
