(* interface du prouveur en logique modale S4 *)
open Format;;
open  Tableau;;


(* lecture et ecriture des commandes *)
 
let read_command channel = 
  Parser.command Lexer.terminal (Lexing.from_channel channel);;


let print_command a =
  open_hvbox 2;
  (match a with
     | Quit -> print_string "quit ;;"
     | (Valid a) -> print_string "valid";
	 print_space () ; Print.print_formula a; print_string " ;;"
     | (Let (x,a)) -> print_string "let ";print_string x; print_string " =";
	 print_space () ; Print.print_formula a;
     | _ -> ());
  close_box (); print_newline ();;

(* (expansion la a) remplace dans la formule a les abréviations 
   par la formule qui leur est associée dans la liste la. 
   Si l'abréviation n'est pas définie, l'exception Not_found est levée *)

let expansion la a = 
  let rec expansion_aux = function
    | ((Var x) as b) -> b  
    | (Abrev x) -> List.assoc x la 
    | (Not a) -> (Not (expansion_aux a))
    | (Nec a) -> (Nec (expansion_aux a))
    | (Pos a) -> (Pos (expansion_aux a))
    | (And (a,b)) -> (And (expansion_aux a, expansion_aux b))
    | (Or (a,b)) -> (Or (expansion_aux a, expansion_aux b))
    | (Imp (a,b)) -> (Imp (expansion_aux a, expansion_aux b))
    | (Equ (a,b)) -> (Equ (expansion_aux a, expansion_aux b))
  in expansion_aux  a;;

(* (print_help ()) prints the list of commands *)

let print_help () =
  print_string "every command must be followed by ;;"; print_newline ();
  print_string "commands are:"; print_newline ();
  print_string "\tquit"; print_newline ();
  print_string "\thelp"; print_newline ();
  print_string "\tsyntax"; 
  print_newline ();print_string "\t  describe the syntax of the formulae";
  print_newline ();
  print_string "\tvalid <formula>";
  print_newline ();
  print_string "\t  verify that the formula is valid or \n\t  give a counter-model of the formula";
  print_newline ();
  print_string "\tlet <identifier> = <formula>";
  print_newline ();print_string "\t  define an abbreviation for the formula";
  print_newline ();print_string "\t  the name of the abbreviation begins with a capital letter";
  print_newline ();print_newline ()  ;;


(* (print_syntax ()) prints the syntax of the formulae *)

let print_syntax () =
  print_string "syntax";  print_newline ();
  print_string "<variable>"; print_newline ();
  print_string "\tstring of letter and digit starting with a small letter";
  print_newline ();
  print_string "<abbreviation>";print_newline ();
  print_string "\tstring of letter and digit starting with a capital letter"; 
  print_newline ();
  print_string "<formula>";print_newline ();
  print_string "\t::= <variable> | <abbreviation> ";
  print_newline ();
  print_string "\t   - <formula> | [] <formula> | <> <formula> | "; 
  print_newline ();
  print_string "\t   <formula> . <formula> | <formula> + <formula> |\n\t   <formula> => <formula> | <formula> <=> <formula> | ";
  print_string "(<formula>)";
  print_newline ();print_newline ();;



(* (do_command rla c) executes the command c.
rla is a reference to a list of abbreviation which could be used or modified
by the command *)
	
exception End;;

let do_command rla = function
  | Quit -> raise End
  |  Help -> print_help ()
  |  Syntax -> print_syntax ()
  | (Valid a) ->  
      let b =  expansion (!rla) a in Prouveur.valid b	
  | (Let(x,a)) -> 
	let b = expansion (!rla) a in 
	rla := (x,b)::!rla ; print_command (Let(x,b))
 ;;


(* (interaction () ) activates the interaction's loop with the user *)

let prompt = ">>";;

let interaction () =
let rla = ref [] in
  try
    while true do
      try 
	(* print the prompt *)
	output_string stdout prompt;
	(* flush stdout;*)
	flush_all ();
	do_command rla (read_command stdin)


      with
	| Lexer.Lexical_error -> 
	    Sys.signal Sys.sigalrm Sys.Signal_ignore;
	    print_string "Lexical error  "; print_newline ()
	| Parsing.Parse_error -> 
	    Sys.signal Sys.sigalrm Sys.Signal_ignore;
	    print_string "Syntax error"; print_newline ()
	| Not_found -> 
	    Sys.signal Sys.sigalrm Sys.Signal_ignore;
	    print_string "Abbreviation not defined";
	    print_newline ()
    done
  with End -> ();;

print_string "Type \"help;;\" for informations";
print_newline ();
interaction () ;;
