%{open Tableau
%}

/* tokens for command */
%token QUIT VALID LET EGAL END  HELP SYNTAX 

/* tokens for formula */
%token LPAR RPAR
%token AND OR NOT IMP EQU 
%token FALSE
%token <string> VAR ABREV 

/* priority */
%left EQU
%right IMP
%left OR
%left AND
%nonassoc NOT 
%start command formula_alone
%type <Tableau.command> command 
%type <Tableau.formula> formula_alone

%%
command :
  | QUIT END 			{Quit}
  | HELP END          {Help}
  | SYNTAX END        {Syntax}
  | VALID formula END 		{Valid $2}
  | LET ABREV EGAL formula END	{Let ($2,$4)}
;

formula :
  | FALSE                      {False}
  | VAR 				{Var $1}
  | ABREV				{Abrev $1}
  | LPAR formula RPAR		{$2}
  | NOT formula			{Not $2}
  | formula AND formula		{And ($1,$3)}
  | formula OR formula		{Or ($1,$3)}
  | formula IMP formula		{Imp ($1,$3)}
  | formula EQU formula		{Equ ($1,$3)}
;

formula_alone :
  | formula END                 {$1}
;



