open Format;;
open Tableau;;

(* affichage d'une formule *)

let print_formula a = 
  let rec prec_formula a =
	match a with
	  | False -> print_string "F"
	  | (Var x) -> print_string x
	  | (Abrev x) -> print_string x
	  | (Not a) -> print_string "-"; prec_formula a
	  | (Nec a) -> print_string "[]";  prec_formula a
	  | (Pos a) -> print_string "<>"; prec_formula a
	  | (And (a,b)) -> print_char '(';
	      prec_formula a; print_space () ;print_string ".";
	      print_space (); prec_formula b;
	      print_char ')'
	  | (Or (a,b)) ->  print_char '(';
	      prec_formula a; print_space (); print_string "+";
	      print_space(); prec_formula b;
	      print_char ')'
	  | (Imp (a,b)) ->  print_char '(';
	      prec_formula a;  print_space (); print_string "=>";
	      print_space (); prec_formula b;
	      print_char ')'
	  | (Equ (a,b)) ->  print_char '(';
	      prec_formula a;  print_space (); print_string "<=>";
	      print_space (); prec_formula b;
	      print_char ')'

  in 
    (open_hvbox 2; prec_formula a ; close_box (); print_flush());;


(* affichage d'une preuve *)

(* let print_case l = print_string "case " ;
  (List.iter (fun x -> print_int x;print_string ".") l); print_newline ();;*)

let print_case l = 
  (* l est une liste d'entiers non vide *)
  print_string "case " ;print_int (List.hd l);
  (List.iter (fun x -> print_string ".";print_int x) (List.tl l)); 
  print_newline ();;
 

let print_assumption_or_arrow a  =
  (match a with 
    | Assumption (p,a) ->
	print_int p; print_string ": "; print_formula a 
    | Arrow (i,j) ->
	print_int i; print_string " -> ";print_int j
  )	
;;


let print_space t = print_string (String.make t ' ');;

  
let tab = 2;;

let print_proof p = 
  (* Affichage d'une preuve p
     A chaque choix, les sous-preuves ont une tabulation 
     augmentée de tab
  *)
  let rec prec_proof t choice p =
    if choice then (print_space t; print_case p.case;);
    print_space t; print_string "(";print_int p.numero;print_string ") ";
    print_assumption_or_arrow p.label;
    (let r = p.from in 
      if r <> 0 then 
	(print_space t; print_string "  from " ;print_int r; 
	 let r2 = p.from2 in
	   if r2 <> 0 then
	     (print_string " and ";print_int r2);
	);
    );
    print_newline ();
    if List.length (p.successor) = 1 
    then
      prec_proof t false (List.hd p.successor)
    else
       (List.iter (fun x -> prec_proof (t+tab) true x) p.successor);
    if choice 
    then (print_space t; print_string "end "; print_case p.case; print_newline() )  
  in  prec_proof 0 false p;;
    


(* Affichage des modèles *)


(* affichage des relations *)

let  print_relation r n = 
  let rm = Array.make (n+1) [] in
    List.iter (function (i,j) -> rm.(i)<-j::rm.(i)) r;
    for i=1 to n do
      let lsucc = rm.(i) in 
	if lsucc<>[] then
	  (print_int i; print_string " -> "; print_int (List.hd (lsucc));
		List.iter (function x -> print_string " , "; print_int x)
			(List.tl (lsucc));
		print_newline ())
    done ;;


let matrix_of_list r n =
(* Le resultat est une matrice  rm représentant la relation r
   avec rm.(i).(j) si et seulement (i,j) est élément de la liste r
*)
  let rm = Array.make_matrix (n+1) (n+1) false in
    List.iter (function (i,j) -> rm.(i).(j)<-true) r;
    rm
;;

let fermetureRT m n = 
  (* resultat : fermeture reflexive et transtive de m*)
  for x = 1 to n do
    for u = 1 to n do
      for v = 1 to n do
	m.(u).(v)<- m.(u).(v) || m.(u).(x) && m.(x).(v)
      done
    done
      (* invariant m.(u).(v)=true ssi il y a un chemin de u à v passant
	 par des sommets intermediaires <= x *)
  done;
  m;;

let filtre m n v i p =
  (* m matrice représentant une relation sur 1,..n
     v.(i) est une liste de variables
     le resultat est vrai ssi i modele de []p *)
  let test = ref true in
    for j = 1 to n do
      if m.(i).(j) && not (List.mem p v.(j)) then test := false
    done;
    !test
;;

     



let rec extract_valuation la = 
  (* la est une liste d'hypothèses 
     la valeur de extract_valuation est la liste des atomes vrais
  *)
  List.fold_left 
    (fun l b -> match b with | (_,((_,Var _)as a)) -> a::l | _ -> l) [] la;;

let select_litteral = function
  | (i, Var x) -> print_string x; 
      print_string " in state ";
      print_int i ; print_newline ()
  | _ -> ();;


let print_assign t =
  print_string "Number of states = ";print_int t.domain; print_newline ();
  print_string "Initial state = ";print_int 1; print_newline ();
  (* ajouter l'affichage de la relation *)
  if t.relation = [] 
  then
    (
      print_string "The accessibility relation is empty"; 
      print_newline ();
    )
  else
    (
      print_string "The accessibility relation is the reflexive and transitive closure of";
      print_newline (); print_string "the following relation :";print_newline ();
      print_relation  t.relation t.domain ;
    );
  (* affichage des variables vraies 
     On met t.relation (liste de couples) sous forme d'une matrice r
     On en calcule la fermeture reflexive et transitive rstar

  *)
  let n = t.domain in
  let rstar = fermetureRT (matrix_of_list t.relation n) n in
  let v = Array.make (n+1) [] in
    (List.iter (fun (_,(i,a)) -> 
		 match a with 
		   |((Var x) as b)  -> v.(i) <- b::v.(i)
		   | _ -> ()
	      ) t.is_done);
  (* v.(i) est la liste des variables vraies dans l'état i pour S4 
     On calcule w.(i) liste des variables p tel que []p vrai dans l'état i
  *)
    let w = Array.make (n+1) [] in
      for i = 1 to n do
	w.(i) <- List.filter (filtre rstar n v i) v.(i)
      done ; 
  
      for i = 1 to n do
	if w.(i)=[] 
	then 
	  (print_string "No variable is true in state ";
	   print_int i; print_newline ())
	else
	  (print_string "The true variables in state ";
	   print_int i; print_string " are : ";
	   (let Var x = List.hd (w.(i)) 
	    in 
	      print_string x;
	      List.iter 
		(fun (Var x) -> print_string ", ";print_string x) (List.tl (w.(i))));
	   print_newline ();
	  )
      done

      
    
 
 



		    
