

(* type of modal formulas *)

type formula =
  | False 
  | Var of string
  | Abrev of string 
  | Or of formula * formula
  | And of formula * formula
  | Equ of formula * formula
  | Imp of formula * formula
  | Not of formula
  | Pos of formula
  | Nec of formula
;;

(* type des commandes de la mini intreface *)

type command =
  | Valid of formula
  | Let of string * formula
  | Quit
  | Help
  | Syntax
;;

(* tableaux *)

type assumption_or_arrow = Assumption of int* formula | Arrow of int*int;;

type arbre = 
    {
      mutable case : int list ;
      mutable label : assumption_or_arrow ; 
      mutable numero : int;
      mutable from : int;
      mutable from2 : int;
      mutable successor : arbre list};;


(* branche  
   la valeur n de domain est le nombre d'états de la branche
   la valeur k de last_number est le numéro de la dernière hypothèse examinée
   la valeur r de relation est une relation sur les états 1 à n 
   la valeur de leaf est une feuille de l'arbre de preuve
   la valeur de todo est la liste des hypothèses non examinées 
   la valeur de is_done est la liste des hypothèses examinées 
 *)

type branch = { mutable domain : int ; 
		mutable last_number : int;
		mutable relation : (int * int) list ; 
		mutable leaf : arbre ;
		mutable todo : (int*(int*formula)) list;
		mutable is_done : (int*(int*formula)) list};;

exception Assign of branch ;;

exception Error_satisfy ;;
















