
open Types;;
open Listc;;
open Resolvant;;
open Subsomption;;
open Arg;;

(* Initialisation du module resolution_po pour les paramètres des preuves *)
let trace = ref false;;
let tres = ref "pos";;

(* contrôle des longueurs et hauteurs des clauses *)
let max_longueur_clause = ref 5;;
let max_hauteur_clause = ref 3;;
let max_taille_clause = ref 20;;

(* contrôle du temps des preuves *)
let delay = ref 10;;
(* fin des initialisations des paramètres des preuves *)

(* ===========================================================================================
 =============================== LITTERAUX ISOLES =============================================
 ============================================================================================ *)

let unifiable l1 l2 = 
  (* résultat : true ssi l1 est unifiable à une copie  l2 de variables disjointes de l1 *)
  let vl1 = vars_litteral l1 and vl2 = vars_litteral l2 in
  let r = renommage vl2 vl1 in 
  try let _ = unifl [l1;(subst_l r l2)] in true with Non_unifiable -> false;;

let est_isole_clause l1 c =
  (* résultat : true ssi l'opposé du littéral l1  n'est unifiable avec aucune copie des littéraux de la clause c *)
  List.for_all (function l2 -> not (unifiable (opp l1) l2)) c.corps;;

let est_isole_liste_clauses l e = 
  (* résultat : true ssi l'opposé du littéral l n'est unifiable avec aucune copie des littéraux des clauses de e*)
  List.for_all (function c -> est_isole_clause l c) e;;

let liste_isoles_clause c e =
  (* résultat : la liste des littéraux isolés de la clause c relativement aux clauses de e *)
  let rec aux c = 
    match c with
      | [] -> []
      | tc::fc -> if est_isole_liste_clauses tc e then tc::aux fc  else aux fc 
  in aux c.corps;;

let liste_isoles e =
  (* résultat : la liste des littéraux isolés des clauses de e *)
  List.fold_left (fun l1 c -> (liste_isoles_clause c (enlever c e))@l1) [] e;;






(* ========================  FIN LITTERAUX ISOLES ============================================= *)



(* Stratégie complète : identique en propositionnelle et au premier ordre *)


let resolvants_clause_liste_de_clauses c lc =  
  (* produit la liste de tous les résolvants de la clause  c et la liste de clauses  lc *)
  List.fold_left (fun lr d -> lr@(resolvants c d)) [] lc;;

let resolvants_liste_de_clauses_liste_de_clauses lc1 lc2 =
  (* produit la liste de tous les résolvants entre les listes de clauses  lc1 et lc2 *)
  List.fold_left (fun lr c -> lr@(resolvants_clause_liste_de_clauses c lc2)) [] lc1;;

let rec resolvants_liste_de_clauses lc = 
  (* produit la liste de tous les résolvants entre les clauses de lc *)
  match lc with
    | [] -> []
    | t::f -> (resolvants_clause_liste_de_clauses t f)@(resolvants_liste_de_clauses f);;


let elimination_inclusion_clauses l  = 
  (* enlève de l les clauses  non minimales pour l'inclusion entre clauses  *)
  reduction inclus_clauses  l;;

let incluant_clauses  c l =
  (* vérifie qu'une clause  de la liste l est incluse dans la clause  c *)
  (List.exists (fun d -> inclus_clauses d c) l);;
  
let simplification_clauses l1 l2 =
  (* enlève de l1 les clauses incluants des clauses de l2 *)
  suppression  (fun c -> incluant_clauses c l2)  l1;;


(* ==========================  AFFICHAGE DES PREUVES ===================================== *)



let rec print_terme t =
  (* 1° ordre : impression du terme t*)
  match t with
    | Var x -> print_string x
    | Comp(f,l) -> print_string f; 
	if l <> [] 
	then (print_string "("; print_terme (List.hd l);
	      List.iter (fun t -> print_string ", "; print_terme t) (List.tl l);
	      print_string ")");;
      

let print_litteral l  = 
  (* 1° ordre : impression du littéral l *)
  match l with
    | Pos v -> print_terme v ; 
    | Neg v -> print_string "-"; print_terme v;
;;


let print_litteraux ll =
  (* impression d'une liste de littéraux *)
  print_string "["; 
  if ll <> [] then
    (print_litteral (List.hd ll); 
     List.iter (fun l -> print_string " "; print_litteral l) (List.tl ll));
  print_string "]";;

let print_substitution s =
  (* affiche une substitution s *)  
  match s with
  (x,t)::fs ->
    ( print_string "     "; print_string x; print_string " := ";print_terme t;
		   List.iter (fun (x,t) -> print_string "; ";
				  print_string x; print_string " := ";print_terme t; ) fs; print_string "\n")
  | _ -> ()
  ;; 


let print_clause_et_numerote c n =
  (* incrémente n puis attribue à la clause c le numéro !n et l'affiche *)
  n := !n +1; c.numero <- !n; print_string "("; print_int !n; print_string ") "; print_litteraux c.corps;;

let print_preuve c =
  (* affiche la preuve de la clause c. Les numéros des clauses servent à deux buts,
  bien présenter la preuve et éviter de répéter des preuves  *)
  let n = ref 0 (*sert à numéroter les étapes de la preuve *) in
  let rec aux_print_preuve c = match c.origine with
    | Hyp -> 
	begin
	  print_clause_et_numerote c n;
	  print_string " Hyp"; print_string "\n"
	end
    | ResBin (c1,c2,s) ->
	begin
	  if c1.numero = 0 then aux_print_preuve c1;
	  if c2.numero = 0 then aux_print_preuve c2;
	  print_clause_et_numerote c n;
	  print_string " Res Bin "; print_int c1.numero; print_string ", "; print_int c2.numero; print_string "\n";
	  print_substitution s 
	end
    | Facteur (c1,s) ->
	begin
	  if c1.numero = 0 then aux_print_preuve c1;
	  print_clause_et_numerote c n;
	  print_string " Factor "; print_int c1.numero; print_string "\n"; 
	  print_substitution s
	end
    | Copie (c1,s) ->
	begin
	  if c1.numero = 0 then aux_print_preuve c1;
	  print_clause_et_numerote c n;
	  print_string " Copy "; print_int c1.numero; print_string "\n"; 
	  print_substitution s
	end
  in aux_print_preuve c;;


  
let print_preuves f  =
  (* affiche les preuves des clauses de la liste f *)
  List.iter (fun c -> print_preuve c; print_string "\n\n") f;;



(* ============================= FIN AFFICHAGE DES PREUVES ==================== *)

(* =================================== Taille Clause  ============================= *)
(* La taille d'une clause est son nombre de symboles tandis que sa longueur est son
nombre de litteraux. Dans la stratégie prover9, on choisit la clause de plus petite taille *)

 

let rec taille_terme t =
  (* resultat : taille du terme t *)
  match t with
    | Var _ -> 1
    | Comp (_,lt) -> 1+ (List.fold_left (fun m1 t -> (taille_terme t)+m1) 0 lt);;

let taille_litteral l =
  (* resultat : taille du litteral l *)
  match l with 
    |Pos t -> taille_terme t
    |Neg t -> 1+ taille_terme t;;

let taille_clause c =
  (* resultat : taille de la clause c *)
  List.fold_left (fun m l -> (taille_litteral l)+ m) 0 c.corps;;

(* =================================== Fin Taille Clause ========================== *)












(* ============================= STRATEGIE COMPLETE =========================== *)

(* Rappel : la clause c résume la clause d, si une instance de c est incluse dans d 
il est évident que l'on peut supprimer les clauses résumées *)


let trace_n = ref 0;;

let delta ="\206\148";;
let theta = "\206\152";;


let traceSc s u =
  print_string (delta^"(");print_int !trace_n;print_string ")\n";
  (match s with
  | [c] -> print_litteraux c.corps
  | c::fs -> print_litteraux c.corps ; List.iter (fun c -> print_string "," ; print_litteraux c.corps) fs
  | [] -> ());
  print_string "\n\n";
  print_string (theta ^ "("); print_int !trace_n;print_string ")\n";
  (match u with
  | [c] -> print_litteraux c.corps
  | c::us -> print_litteraux c.corps ; List.iter (fun c -> print_string ","; print_litteraux c.corps) us
  | [] -> ());
  print_string "\n\n";;







let rec sc e f  = 
  (* sc est une réalisation récursive terminale de la stratégie complète. 
     (sc [] f) affiche les preuves des clauses de la liste f
     (sc e f) où e <> f, appelle (sc es fs) où
     la liste de clauses es est obtenue 
     - en construisant l'ensemble lr de tous les résolvants 
       entre les clauses de e et celles de e @ f
     - en enlevant les clauses valides, celles résumées par une autre clause de lr, celles
       résumées par une clause de e @ f 
     la liste de clauses fs est obtenue
     - en enlevant de e @ f les clauses résumées par une clause de es
  *)
  if !trace then traceSc e f;
  if e = [] 
  then
  ( 
  match f with
    | [c] -> if c.corps = [] then 
             (print_preuve c)
            else (print_string "There is no proof of the empty clause\n")
    | _ ->  print_string "There is no proof of the empty clause\n"

   ) 
  else 
    let ef = e @ f in 
    let lre = resolvants_liste_de_clauses e in
    let lref = resolvants_liste_de_clauses_liste_de_clauses e f in
    let lr = lre @ lref in
      (* lr est la liste de tous les résolvants entre les clauses de et celles de e à f *)
    let es = simplification_clauses (elimination_inclusion_clauses (suppression_valides lr)) ef in
    let fs = simplification_clauses ef es in

      (* suppression des litteraux isolés 
    let li = liste_isoles (es@fs) in
    let esmi = suppression (fun c -> not (disjoint li c.corps)) es in
    let fsmi = suppression (fun c -> not (disjoint li c.corps)) fs in
       fin suppression des littéraux isolés *)


      (* suppression des clauses  de trop grande taille, trop longues ou trop hautes *)
      
    let esmtrop = suppression 
		    (fun c -> 
	       	 ((hauteur_clause c) > !max_hauteur_clause) || 
		       ((List.length c.corps)> !max_longueur_clause) ||  
                       (taille_clause c > !max_taille_clause)) es in
    let fsmtrop = suppression 
		    (fun c -> 
			 ((hauteur_clause c) > !max_hauteur_clause) || 
		       ((List.length c.corps)> !max_longueur_clause) ||  
		       (taille_clause c > !max_taille_clause)) fs in
      (* fin suppression des clauses trop longues ou trop hautes *)
      (trace_n := !trace_n + 1; sc esmtrop fsmtrop);;
	 

let algo31 e =
  (* La stratégie complète est appliquée à la liste e de clauses et
     affiche l'ensemble des preuves des conséquences minimales de e *)
  let e1 = (elimination_inclusion_clauses (suppression_valides (ens_de_liste e))) in

    (* suppression des litteraux isolés pour être fidèle au cours on ne fait pas cette suppression
  let li = liste_isoles e1 in
  let e1mi = suppression (fun c -> not (disjoint li c.corps)) e1 in 
     fin suppression des littéraux isolés *)

    (trace_n:=0;sc e1 []) ;;



(* =============================== FIN STATEGIE COMPLETE ====================== *)
 

(* ============================ CONTROLE DU TEMPS D'EXECUTION ================= *)

(*  on arrête les preuves au bout de !delay secondes *)

let start = ref 0.0;;


exception Too_long;;

let clock  = Sys.Signal_handle (function _ -> raise Too_long);;

let print_time () = print_string "Proof duration (in seconds): ";
  print_float (Unix.gettimeofday() -. !start); print_newline ();;

let algo31borne e =
  (* méthode de résolution avec limite de temps delay *)
  try 
    (Sys.set_signal Sys.sigalrm clock; let _ = Unix.alarm !delay in ();
    start := Unix.gettimeofday();
    algo31 e;
    print_time();
    Sys.set_signal Sys.sigalrm Sys.Signal_ignore; ())
  with 
    Too_long ->   (
		     Sys.set_signal Sys.sigalrm Sys.Signal_ignore;
		   print_string "interrupted proof (more than ";print_int !delay;print_string " seconds)\n");;

 (* ======================= FIN CONTROLE DU TEMPS D'EXECUTION =================== *)   







 
(* appel de preuve avec les arguments pour modifier les paramétres
   -trace -notrace -res pos (resp. neg, nor) -maxl int -maxh int -temps int -s string
   (cette chaîne est  le nom du fichier contenant les clauses)
   *)

let lire_clauses buffer =
(* lecture d'une liste de clauses suivie de point virgule dans buffer *)
Parser.clauses_fin Lexer.terminal buffer;;



exception ErreurTypeRes of string;;


let preuve_par_resolution () =
  let file = ref ""  in  
  let parametres = ["-trace",Set trace,"Activate trace"; "-notrace", Clear trace,"Desactivate trace";
		    "-res",Set_string tres,"Choose the type nor,neg or pos of resolution";
		    "-maxl", Set_int max_longueur_clause,"n, n is an integer, maximum length of clauses";
		    "-maxh", Set_int max_hauteur_clause,"h, h is an integer, maximum height of clauses";
		    "-maxs", Set_int max_taille_clause,"s, s is an integer, maximum size of clauses";
		    "-t",Set_int delay,"d, d is an integer, maximum duration in seconds of the proof";
		    "-s", Set_string file, "f, f is a string, name of the file containing the clauses, 
		      from which we try to deduce the empty clause"] in
		      parse parametres   print_endline    "";
		    if !file <> "" then
		      begin
		    try 
		      (match (!tres) with
		      | "neg" -> type_resolution := neg
		      | "pos" -> type_resolution := pos
		      | "nor" -> type_resolution := nor;
		      | _ -> raise  (ErreurTypeRes !tres));
		      let buffer = Lexing.from_channel (open_in (!file)) in
		      try
			(let lc = lire_clauses buffer in
			print_string "result.\n"; algo31borne lc)
		      with (* filtrage des erreurs lexicales et syntaxiques *)
		      | Lexer.Erreur_lexicale | Parsing.Parse_error ->
			  print_string "error.\n";
			  print_string "The list of clauses is incorrect line ";
			  let p = Lexing.lexeme_start_p buffer in
			  (print_int p.Lexing.pos_lnum;
			   print_string " caracter ";
			   print_int (1+p.Lexing.pos_cnum - p.Lexing.pos_bol));
			  print_newline ()
		    with ErreurTypeRes r -> print_string (r^" : incorrect resolution type\n")
		      end
		    else print_endline "The clauses file is missing; try option -help";;

 
preuve_par_resolution ();;


  

