open Listc;;
open Types;;
open Resolvant;;

(* ====================================================================================
 ======== SUBSOMPTION ENTRE CLAUSES (1° ordre) =========================================
 ======================================================================================= *)



(* ===================================== FILTRAGE (1° ordre) ========================== *)

exception Echec_filtre ;;

let rec filtre_aux s u v =
  (* s est une substitution, u et v sont des termes, 
     résultat : une substitution s' extension de s tel que s'(u) = v 
     lève l'exception Echec_filtre si cette substitution  n'existe pas *)
  match u with
    | Var x -> (try if List.assoc x s = v then s else raise Echec_filtre
		with Not_found -> (x,v)::s)
    | Comp (f,lf) -> (match v with
		       | Var _ -> raise Echec_filtre
		       | Comp (g,lg) -> if f = g then filtre_aux_liste s lf lg else raise Echec_filtre)
and filtre_aux_liste s lf lg =
  match lf,lg with
      [],[] -> s
    | tf::ff, tg::fg -> filtre_aux_liste (filtre_aux s tf tg) ff fg
    | _ -> raise Echec_filtre;;

let filtre_termes t1 t2 =
  (* t1 et t2 sont des termes
     résultat : une substitution s telle que s(t1) = t2 
     lève l'exception Echec_filtre si cette substitution n'existe pas *)
  filtre_aux [] t1 t2;;

let filtre_litteraux l1 l2 =
  (* l1 et l2 sont des littéraux, 
     résultat : une substitution s tel que s(l1) = l2 
     lève l'exception Echec_filtre si cette subsitution n'existe pas *)
  match l1,l2 with
    | Pos t1, Pos t2 -> filtre_termes t1 t2
    | Neg t1, Neg t2 -> filtre_termes t1 t2
    | _ -> raise Echec_filtre;;

(* =======================================  FIN FILTRAGE ============================ *)

let rec geler_terme t = 
  (* t est un terme
     résultat : le terme dans lequel toute variable (Var x) est remplacée par la constante (Comp (x,[]))
  *)
  match t with
    | Var x -> Comp (x,[])
    | Comp(f,lt) -> Comp(f,List.map geler_terme lt);;

let geler_litteral l = 
  (* l est un littéral
     résultat : le littéral dans lequel toute variable (Var x) est remplacée par la constante (Comp (x,[]))
  *)
  match l with
    | Pos t -> Pos (geler_terme t)
    | Neg t -> Neg (geler_terme t);;





let rec filtre c1 c2 =
  (* c1 et c2 sont des listes de littéraux, c2 n'a pas de variable
  résultat : true si et seulement si il y a une substitution s telle que s(c1) est inclus dans c2*)
  match c1 with
    | [] -> true
    | t ::f -> List.exists 
	(function l -> 
	   try let s = filtre_litteraux t l in filtre (List.map (subst_l s) f) c2
           with Echec_filtre -> false)
	c2;;

let inclus_clauses c1 c2 =
  (* résultat : true si et seulement la clause c1 subsume la clause  c2, 
     autrement dit s'il existe une substitution s telle que s(c1) est inclus dans c2 *)
  filtre c1.corps (List.map geler_litteral c2.corps);;


(* =========================== FIN SUBSOMPTION ============================================== *)
