open Types;;
open Listc;;
open Resolvant;;
open Subsomption;;
open Arg;;



(* ===========================================================================================
 =============================== LITTERAUX ISOLES =============================================
 ============================================================================================ *)

let unifiable l1 l2 = 
  (* résultat : true ssi l1 est unifiable à une copie  l2 de variables disjointes de l1 *)
  let vl1 = vars_litteral l1 and vl2 = vars_litteral l2 in
  let r = renommage vl2 vl1 in 
  try let _ = unifl [l1;(subst_l r l2)] in true with Non_unifiable -> false;;

let est_isole_clause l1 c =
  (* résultat : true ssi l'opposé du littéral l1  n'est unifiable avec aucune copie des littéraux de la clause c *)
  List.for_all (function l2 -> not (unifiable (opp l1) l2)) c.corps;;

let est_isole_liste_clauses l e = 
  (* résultat : true ssi l'opposé du littéral l n'est unifiable avec aucune copie des littéraux des clauses de e*)
  List.for_all (function c -> est_isole_clause l c) e;;

let liste_isoles_clause c e =
  (* résultat : la liste des littéraux isolés de la clause c relativement aux clauses de e *)
  let rec aux c = 
    match c with
      | [] -> []
      | tc::fc -> if est_isole_liste_clauses tc e then tc::aux fc  else aux fc 
  in aux c.corps;;

let liste_isoles e =
  (* résultat : la liste des littéraux isolés des clauses de e *)
  List.fold_left (fun l1 c -> (liste_isoles_clause c (enlever c e))@l1) [] e;;






(* ========================  FIN LITTERAUX ISOLES ============================================= *)

(* =================================== CHOIX CLAUSE 2011 ============================= *)
(* La taille d'une clause est son nombre de symboles tandis que sa longueur est son
nombre de litteraux. Dans la stratégie prover9, on choisit la clause de plus petite taille *)

 

let rec taille_terme t =
  (* resultat : taille du terme t *)
  match t with
    | Var _ -> 1
    | Comp (_,lt) -> 1+ (List.fold_left (fun m1 t -> (taille_terme t)+m1) 0 lt);;

let taille_litteral l =
  (* resultat : taille du litteral l *)
  match l with 
    |Pos t -> taille_terme t
    |Neg t -> 1+ taille_terme t;;

let taille_clause c =
  (* resultat : taille de la clause c *)
  List.fold_left (fun m l -> (taille_litteral l)+ m) 0 c.corps;;

(* =================================== FIN CHOIX CLAUSE 2011 ========================== *)







(* Stratégie complète : identique en propositionnelle et au premier ordre *)


let resolvants_clause_liste_de_clauses c lc =  
  (* produit la liste de tous les résolvants de la clause  c et la liste de clauses  lc *)
  List.fold_left (fun lr d -> lr@(resolvants c d)) [] lc;;

let resolvants_liste_de_clauses_liste_de_clauses lc1 lc2 =
  (* produit la liste de tous les résolvants entre les listes de clauses  lc1 et lc2 *)
  List.fold_left (fun lr c -> lr@(resolvants_clause_liste_de_clauses c lc2)) [] lc1;;

let rec resolvants_liste_de_clauses lc = 
  (* produit la liste de tous les résolvants entre les clauses de lc *)
  match lc with
    | [] -> []
    | t::f -> (resolvants_clause_liste_de_clauses t f)@(resolvants_liste_de_clauses f);;


let elimination_inclusion_clauses l  = 
  (* enlève de l les clauses  non minimales pour l'inclusion entre clauses  *)
  reduction inclus_clauses  l;;

let incluant_clauses  c l =
  (* vérifie qu'une clause  de la liste l est incluse dans la clause  c *)
  (List.exists (fun d -> inclus_clauses d c) l);;
  
let simplification_clauses l1 l2 =
  (* enlève de l1 les clauses incluants des clauses de l2 *)
  suppression  (fun c -> incluant_clauses c l2)  l1;;


(* ==========================  AFFICHAGE DES PREUVES ===================================== *)



let rec print_terme t =
  (* 1° ordre : impression du terme t*)
  match t with
    | Var x -> print_string x
    | Comp(f,l) -> print_string f; 
	if l <> [] 
	then (print_string "("; print_terme (List.hd l);
	      List.iter (fun t -> print_string ", "; print_terme t) (List.tl l);
	      print_string ")");;
      

let print_litteral l  = 
  (* 1° ordre : impression du littéral l *)
  match l with
    | Pos v -> print_terme v ; 
    | Neg v -> print_string "-"; print_terme v;
;;


let print_litteraux ll =
  (* impression d'une liste de littéraux *)
  print_string "["; 
  if ll <> [] then
    (print_litteral (List.hd ll); 
     List.iter (fun l -> print_string " "; print_litteral l) (List.tl ll));
  print_string "]";;

let print_substitution s =
  (* affiche une substitution s *)  
  match s with
  (x,t)::fs ->
    ( print_string "     "; print_string x; print_string " := ";print_terme t;
		   List.iter (fun (x,t) -> print_string "; ";
				  print_string x; print_string " := ";print_terme t; ) fs; print_string "\n")
  | _ -> ()
  ;; 


let print_clause_et_numerote c n =
  (* incrémente n puis attribue à la clause c le numéro !n et l'affiche *)
  n := !n +1; c.numero <- !n; print_string "("; print_int !n; print_string ") "; print_litteraux c.corps;;

let print_preuve c =
  (* affiche la preuve de la clause c. Les numéros des clauses servent à deux buts,
  bien présenter la preuve et éviter de répéter des preuves  *)
  let n = ref 0 (*sert à numéroter les étapes de la preuve *) in
  let rec aux_print_preuve c = match c.origine with
    | Hyp -> 
	begin
	  print_clause_et_numerote c n;
	  print_string " Hyp"; print_string "\n"
	end
    | ResBin (c1,c2,s) ->
	begin
	  if c1.numero = 0 then aux_print_preuve c1;
	  if c2.numero = 0 then aux_print_preuve c2;
	  print_clause_et_numerote c n;
	  print_string " Res Bin "; print_int c1.numero; print_string ", "; print_int c2.numero; print_string "\n";
	  print_substitution s 
	end
    | Facteur (c1,s) ->
	begin
	  if c1.numero = 0 then aux_print_preuve c1;
	  print_clause_et_numerote c n;
	  print_string " Factor "; print_int c1.numero; print_string "\n"; 
	  print_substitution s
	end
    | Copie (c1,s) ->
	begin
	  if c1.numero = 0 then aux_print_preuve c1;
	  print_clause_et_numerote c n;
	  print_string " Copy "; print_int c1.numero; print_string "\n"; 
	  print_substitution s
	end
  in aux_print_preuve c;;


  
let print_preuves f  =
  (* affiche les preuves des clauses de la liste f *)
  List.iter (fun c -> print_preuve c; print_string "\n\n") f;;



(* ============================= FIN AFFICHAGE DES PREUVES ==================== *)

(* ============================= STRATEGIE COMPLETE =========================== *)

(* Rappel : la clause c résume la clause d, si une instance de c est incluse dans d 
il est évident que l'on peut supprimer les clauses résumées *)

let trace = ref false;;

let trace_n = ref 0;;

let traceSc s u =
  print_string "s(";print_int !trace_n;print_string ")\n";
  (match s with
  | [c] -> print_litteraux c.corps
  | c::fs -> print_litteraux c.corps ; List.iter (fun c -> print_string "," ; print_litteraux c.corps) fs
  | [] -> ());
  print_string "\n\n";
  print_string "u("; print_int !trace_n;print_string ")\n";
  (match u with
  | [c] -> print_litteraux c.corps
  | c::us -> print_litteraux c.corps ; List.iter (fun c -> print_string ","; print_litteraux c.corps) us
  | [] -> ());
  print_string "\n\n";;

(* contrôle des longueurs et hauteurs des clauses *)

let max_longueur_clause = ref 5;;
let max_hauteur_clause = ref 4;;
let max_taille_clause = ref 30;;

(* STRATEGIE DU SUPPORT ET DE PROVER9 *)


let choix_clause = ref "size";;

let choix c = match !choix_clause with 
 |   "height" -> hauteur_clause c
 |   "length" -> List.length c.corps
 |   "size" -> taille_clause c
 |    _ -> failwith "choix de clause non prévu"  
;;


let rec minimum s =
  (* resultat : la clause la plus au début 
de la liste s de hauteur, longueur ou taille minimum suivant le choix effectué. Pour obtenir la clause minimum
la plus à la fin de cette liste, il suffit de remplacer choix c <= choix d par choix c < choix d  *)
  match s with
    | [c] -> c
    | c::fin -> let d = minimum fin in
        if choix c <= choix d then c else d
    | _ -> failwith "erreur dans choix d'une clause"
;;


let hors_support_initial = ref [];;

(* trace pour corriger le programme *)
 let print_clause c =  print_litteraux c.corps; print_newline ();;


let rec sc1 s u = 
(* l'algorithme de prouveur9 *)

  if (!trace) then traceSc s u;
  if s = [] then 
   ( match u with
    | [c] -> if c.corps = [] then 
             print_preuve c
            else print_string "Unable to prove the empty clause\n"
    | _ ->  print_string "Unable to prove the empty clause\n")

  else
    (* choix de la clause c voir p51 de notre livre *)
let c = minimum s in
let n = resolvants_clause_liste_de_clauses c u in
let p = elimination_inclusion_clauses (suppression_valides n) in
let q = simplification_clauses p (s@u) in
let ssuivant = 
(simplification_clauses (suppression (fun d -> d = c) s) q) @ q in
let usuivant =
if incluant_clauses c u 
then simplification_clauses u q
else simplification_clauses (c::u) q
in
   (* suppression des clauses de tailles trop grandes *)

let strop = suppression (fun c -> ((taille_clause c) > !max_taille_clause)) ssuivant in
let utrop = suppression (fun c -> ((taille_clause c) > !max_taille_clause)) usuivant in
(trace_n:= !trace_n+1;sc1 strop utrop);;

	  
	 

let algo31 e =
  (* La stratégie complète est appliquée à la liste e de clauses et
     affiche l'ensemble des preuves des conséquences minimales de e *)
  let e1 = (elimination_inclusion_clauses (suppression_valides (ens_de_liste e))) in
    (* suppression des litteraux isolés 
       let li = liste_isoles e1 in
       let e1mi = suppression (fun c -> not (disjoint li c.corps)) e1 in 
       fin suppression des littéraux isolés *)
    (trace_n:=0;sc1  e1 (!hors_support_initial)) ;;


	 

(* =============================== FIN STATEGIE COMPLETE ====================== *)
 

(* ============================ CONTROLE DU TEMPS D'EXECUTION ================= *)

(*  on arrête les preuves au bout de !delay secondes *)

let start = ref 0.0;;

let delay = ref 10;;

exception Too_long;;

let clock  = Sys.Signal_handle (function _ -> raise Too_long);;

let print_time () = print_string "Proof duration (in seconds): ";
  print_float (Unix.gettimeofday() -. !start); print_newline ();;

let algo31borne e =
  (* méthode de résolution avec limite de temps delay *)
  try 
    (Sys.set_signal Sys.sigalrm clock; let _ = Unix.alarm !delay in ();
    start := Unix.gettimeofday();
    algo31 e;
    print_time();
    Sys.set_signal Sys.sigalrm Sys.Signal_ignore; ())
  with 
      Too_long ->   (Sys.set_signal Sys.sigalrm Sys.Signal_ignore;
	print_string "interrupted proof (more than ";print_int !delay;print_string " seconds)\n");;

 (* ======================= FIN CONTROLE DU TEMPS D'EXECUTION =================== *)   


 



 
(* appel de preuve avec les arguments pour modifier les paramétres
   -trace -notrace -res pos (resp. neg, nor) -maxl int -maxh int -temps int -in string
   (si cette chaîne est f, c'est le nom du fichier contenant les clauses)
   *)

let lire_clauses buffer =
(* lecture d'une liste de clauses suivie de point virgule dans buffer *)
Parser.clauses_fin Lexer.terminal buffer;;


let support_initial = ref [];;
let erreur_syntaxique = ref false;;
exception ErreurTypeRes of string;;
exception SupportVide of string;;

let tres = ref "nor";; 

let preuve_par_resolution () =

let sfichier = ref "" and nsfichier = ref "" in

let parametres = ["-trace",Set trace,"Activate the trace"; "-notrace", Clear trace,"Desactivate the trace";
"-res", Set_string tres,"Choose the type of resolution (nor,pos or neg)";
"-maxl", Set_int max_longueur_clause,"n, n is an integer, maximal length of clauses";
"-maxh", Set_int max_hauteur_clause,"h, h is an integer, maximal height of clauses";
"-maxs",Set_int max_taille_clause,"s, s is an integer, maximal size of clauses";
"-t",Set_int delay, "s, s is an integer, maximal time (in secunds) of the proof";
"-ns", Set_string nsfichier, "f, f is the name of the file containing the clauses out of the support";
"-s", Set_string sfichier,"f, f is the name of the file containing the clauses of the support";
"-ch",Set_string choix_clause,"Choose the way to select the chosenclause"] in
parse parametres  (fun x -> ()) "";
try
(*
(match !tres with
| "nor" -> type_resolution := nor
| "neg" -> type_resolution := neg
| "pos" -> type_resolution := pos
| _ -> raise (ErreurTypeRes (!tres)));
*)


(* lecture du fichier des clauses du support *)
(
if !sfichier ="" then raise( SupportVide "The support must not be empty")
else 
 let sbuffer = Lexing.from_channel (open_in (!sfichier)) in
 try
    support_initial := lire_clauses sbuffer;
    if !support_initial = [] then raise(SupportVide "The support must not be empty")
    
 with
    (* filtrage des erreurs lexicales et syntaxiques *)
    | Lexer.Erreur_lexicale | Parsing.Parse_error ->
    (print_string "error.\n";
		  print_string "The support clauses are incorrect line ";
		  let p = Lexing.lexeme_start_p sbuffer in
		  (print_int p.Lexing.pos_lnum;
			     print_string " character ";
			     print_int (1+p.Lexing.pos_cnum - p.Lexing.pos_bol));
		  print_newline ();
		  erreur_syntaxique := true ))
					;
			   

(* fin lecture des clauses du support *)
 
(* lecture, s'il existe, du fichier des clauses qui ne sont pas dans le support *)
if ((!nsfichier <> "") && (not !erreur_syntaxique)) then
(let nsbuffer = Lexing.from_channel (open_in (!nsfichier))
 in 
try 
hors_support_initial:= lire_clauses nsbuffer
with
  (* filtrage des erreurs lexicales et syntaxiques du fichier des clauses du support *)
  | Lexer.Erreur_lexicale | Parsing.Parse_error ->
(print_string "error.\n";
	      print_string "The usable clauses are incorrect line ";
	      let p = Lexing.lexeme_start_p nsbuffer in
	      (print_int p.Lexing.pos_lnum;
			 print_string " character ";
			 print_int (1+p.Lexing.pos_cnum - p.Lexing.pos_bol));
	      print_newline ()); erreur_syntaxique := true ;);
(* fin lecture des clauses hors  support *)

if not (!erreur_syntaxique) then (print_string "result.\n";algo31borne (!support_initial))

with SupportVide r -> print_string ("error.\n"^r^"\n")
| ErreurTypeRes r -> print_string ("error.\n"^r^"  wrong resolution type \n")

;;

preuve_par_resolution ();;

  

